/*
 * Decompiled with CFR 0.152.
 */
package io.github.lukebemish.dynamic_asset_generator.client.util;

import io.github.lukebemish.dynamic_asset_generator.client.palette.ColorHolder;
import io.github.lukebemish.dynamic_asset_generator.client.palette.Palette;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class Clusterer {
    Map<ColorHolder, Integer> assignmentMap = new HashMap<ColorHolder, Integer>();
    List<Cluster> sampleList = new ArrayList<Cluster>();
    double cutoff = -1.0;
    double distWeight = 0.0;

    private void run() {
        int size = this.sampleList.size();
        while (size > 2) {
            int xF = 0;
            int yF = 1;
            double minNon0Dist = this.sampleList.get(0).dist(this.sampleList.get(1), this.distWeight);
            for (int x = 0; x < this.sampleList.size(); ++x) {
                for (int y = 0; y < this.sampleList.size(); ++y) {
                    double d;
                    if (x == y || !((d = this.sampleList.get(x).dist(this.sampleList.get(y), this.distWeight)) < minNon0Dist)) continue;
                    minNon0Dist = d;
                    xF = x;
                    yF = y;
                }
            }
            if (!(this.cutoff < 0.0) && !(minNon0Dist < this.cutoff)) break;
            Cluster toAdd = this.sampleList.get(xF);
            toAdd.merge(this.sampleList.remove(yF));
            size = this.sampleList.size();
        }
        int i = 0;
        for (Cluster c : this.sampleList) {
            for (ColorHolder v : c) {
                this.assignmentMap.put(v, i);
            }
            ++i;
        }
    }

    public boolean isInCategoryWith(ColorHolder a, ColorHolder b) {
        return this.assignmentMap.getOrDefault(a, -1).equals(this.assignmentMap.getOrDefault(b, -2));
    }

    public int getCategory(ColorHolder v) {
        return this.assignmentMap.getOrDefault(v, -1);
    }

    public static Clusterer createFromPalettes(double distWeight, Function<Cluster, Double> cutoffFromBackground, Palette bg, Palette ... ps) {
        Clusterer out = new Clusterer();
        out.distWeight = distWeight;
        HashSet samples = new HashSet();
        for (Palette p : ps) {
            p.getStream().forEach(samples::add);
        }
        Cluster bgCluster = new Cluster();
        Iterator<ColorHolder> iterator = bg.getStream().toList().iterator();
        while (iterator.hasNext()) {
            ColorHolder c;
            ColorHolder v = c = iterator.next();
            samples.remove(v);
            bgCluster.add(v);
        }
        out.sampleList.add(bgCluster);
        for (ColorHolder v : samples) {
            out.sampleList.add(Cluster.single(v));
        }
        out.cutoff = cutoffFromBackground.apply(bgCluster);
        out.run();
        return out;
    }

    public static Clusterer createFromPalettes(Palette bg, Palette ... ps) {
        return Clusterer.createFromPalettes(0.0, (Cluster c) -> 0.0, bg, ps);
    }

    public int numCategories() {
        return this.sampleList.size();
    }

    public static class Cluster
    extends ArrayList<ColorHolder> {
        public double dist(Cluster other, double weight) {
            double min = ((ColorHolder)this.get(0)).distanceToLab((ColorHolder)other.get(0), 0.2f);
            double avg = 0.0;
            int count = 0;
            for (ColorHolder f : this) {
                for (ColorHolder c : other) {
                    double d = f.distanceToLab(c, 0.2f);
                    avg += d;
                    ++count;
                    if (!(d < min)) continue;
                    min = d;
                }
            }
            return min * (1.0 - weight) + avg / (double)count * weight;
        }

        public static Cluster single(ColorHolder v) {
            Cluster c = new Cluster();
            c.add(v);
            return c;
        }

        public void merge(Cluster cluster) {
            this.addAll(cluster);
        }

        public double minDist() {
            if (this.size() <= 1) {
                return 0.0;
            }
            double m = ((ColorHolder)this.get(0)).distanceToLab((ColorHolder)this.get(1));
            for (ColorHolder x : this) {
                for (ColorHolder y : this) {
                    double d;
                    if (x == y || !((d = x.distanceToLab(y, 0.2f)) < m)) continue;
                    m = d;
                }
            }
            return m;
        }

        public double maxDist() {
            double m = ((ColorHolder)this.get(0)).distanceToLab((ColorHolder)this.get(0), 0.2f);
            for (ColorHolder x : this) {
                for (ColorHolder y : this) {
                    double d = x.distanceToLab(y, 0.2f);
                    if (!(d > m)) continue;
                    m = d;
                }
            }
            return m;
        }

        public double avgDist() {
            double m = 0.0;
            int c = 0;
            for (ColorHolder x : this) {
                for (ColorHolder y : this) {
                    if (x.equals(y)) continue;
                    m += x.distanceToLab(y, 0.2f);
                    ++c;
                }
            }
            return m / (double)c;
        }
    }
}

